/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class HopcroftKarp<V, U> {
    private Multimap<V, U> adj = ArrayListMultimap.create();
    private Map<V, U> pairG1 = Maps.newHashMap();
    private Map<U, V> pairG2 = Maps.newHashMap();
    private Map<V, Integer> dist = Maps.newHashMap();

    public static <V, U> HopcroftKarp<V, U> create() {
        return new HopcroftKarp<V, U>();
    }

    public void addEdge(V v, U u) {
        Preconditions.checkNotNull(v);
        Preconditions.checkNotNull(u);
        this.pairG1.put(v, null);
        this.pairG2.put(u, null);
        this.adj.put(v, u);
    }

    private boolean bfs() {
        LinkedList<V> q = Lists.newLinkedList();
        for (Map.Entry<V, U> entry : this.pairG1.entrySet()) {
            V v = entry.getKey();
            U pairU = entry.getValue();
            if (pairU == null) {
                this.dist.put((Integer)v, 0);
                q.addLast(v);
                continue;
            }
            this.dist.put((Integer)v, -1);
        }
        this.dist.put(null, -1);
        while (!q.isEmpty()) {
            Object v = q.pop();
            for (U u : this.adj.get(v)) {
                V v2 = this.pairG2.get(u);
                if (this.dist.get(v2) != -1) continue;
                this.dist.put((Integer)v2, this.dist.get(v) + 1);
                if (v2 == null) continue;
                q.addLast(v2);
            }
        }
        return this.dist.get(null) != -1;
    }

    private boolean dfs(V v) {
        if (v != null) {
            for (U u : this.adj.get(v)) {
                V v2 = this.pairG2.get(u);
                if (this.dist.get(v2) != this.dist.get(v) + 1 || !this.dfs(v2)) continue;
                this.pairG1.put(v, u);
                this.pairG2.put(u, v);
                return true;
            }
            this.dist.put((Integer)v, -1);
            return false;
        }
        return true;
    }

    public int run() {
        Preconditions.checkState(!this.pairG1.isEmpty(), "There are no edges.");
        Preconditions.checkState(this.dist.isEmpty(), "HopcroftKarp.run() cannot be executed multiple times.");
        int matching = 0;
        while (this.bfs()) {
            for (Map.Entry<V, U> entry : this.pairG1.entrySet()) {
                V v = entry.getKey();
                U u = entry.getValue();
                if (u != null || !this.dfs(v)) continue;
                ++matching;
            }
        }
        return matching;
    }

    public Map<V, U> getPairing() {
        return Collections.unmodifiableMap(this.pairG1);
    }
}

